/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* ***********************************************************************
   *                                                                     *
   * sst_prim.c                                                          *
   * Christian Zurhorst, BVS R&D, 29. Jul. 1998                          *
   *                                                                     *
   * SST primiteves                                                      *
   *                                                                     *
   ***********************************************************************
*/

#ifdef BEST_FIRMWARE

#include <capitype.h>


#else

#include <typedefs.h>

#endif


#include <errcapi.h>
#include <iocommon.h>
#include <regx60.h>
#include <regx61.h>
#include <session.h>
#include <sst_prim.h>
#include <sst_prop.h>


#ifndef BEST_FIRMWARE

static b_int8 report_storage [MAXHANDLES + 1] [B_SST_RPT_MAXSIZE];


static b_errtype sst_prim_stop (b_handletype handle)
{
  B_TRY_VARS_NO_PROG;
  b_int32 present;
  
  B_TRY_BEGIN {
    B_TRY (BestSstPrimPresent (handle, &present));
      
    if (present) {
      B_TRY (BestBasicCommand (handle, CMD_SST_PRIM_STOP,
			       NULL, IN_SST_PRIM_STOP, NULL, NULL));
      }
  }

  return B_TRY_RET;
}


b_errtype EXPORT BestSstPrimRun (b_handletype handle)
{
  B_TRY_VARS_NO_PROG;
  b_int32 present;
  
  B_TRY_BEGIN {

    if (BestHasIchiban (handle)) {
      /* just ignore if board is reset -> re-use present */
      B_TRY (BestBasicIsBoardReset(handle, &present));

      B_TRY (BestSstPrimPresent (handle, &present));
      
      if (present) {
	B_TRY (BestSstPrimStop (handle));
      }
    }

    /* make sure nothing is locked anymore, both GUI and SST fight
       for everything! */
    if (BestHasIchiban(handle))
    {
      B_TRY (BestAllResourceUnlock(handle));
    }
    B_TRY (BestSstPropSet(handle, B_SSTPAR_EVENT, B_EVENT_RUN));

    if (BestHasIchiban (handle)) {
      B_TRY (BestBasicCommand (handle, CMD_SST_PRIM_RUN,
			       NULL, IN_SST_PRIM_RUN, NULL, NULL));
    }
  }

  return B_TRY_RET;
}


b_errtype EXPORT BestSstPrimContinue (b_handletype handle)
{
  B_TRY_VARS_NO_PROG;
  
  B_TRY_BEGIN {
    B_TRY (BestSstPropSet(handle, B_SSTPAR_EVENT, B_EVENT_CONTINUE));

    if (BestHasIchiban (handle)) {
      B_TRY (BestBasicCommand (handle, CMD_SST_PRIM_RUN,
			       NULL, IN_SST_PRIM_RUN, NULL, NULL));
    }
  }

  return B_TRY_RET;
}


b_errtype EXPORT BestSstPrimStop (b_handletype handle)
{
  B_TRY_VARS_NO_PROG;

  B_TRY_BEGIN {
    B_TRY (BestSstPropSet (handle, B_SSTPAR_EVENT, B_EVENT_STOP));

    if (BestHasIchiban (handle)) {
      B_TRY (sst_prim_stop (handle));
    }
  }

  return B_TRY_RET;
}


b_errtype EXPORT BestSstPrimPause (b_handletype handle)
{
  B_TRY_VARS_NO_PROG;
  
  B_TRY_BEGIN {
    B_TRY (BestSstPropSet (handle, B_SSTPAR_EVENT, B_EVENT_PAUSE));

    if (BestHasIchiban (handle)) {
      B_TRY (BestBasicCommand (handle, CMD_SST_PRIM_STOP,
			       NULL, IN_SST_PRIM_STOP, NULL, NULL));
    }
  }

  return B_TRY_RET;
}


b_errtype EXPORT BestSstPrimAbort (b_handletype handle)
{
  B_TRY_VARS_NO_PROG;
  
  B_TRY_BEGIN {
    B_TRY (BestSstPropSet (handle, B_SSTPAR_EVENT, B_EVENT_ABORT));

    if (BestHasIchiban (handle)) {
      B_TRY (sst_prim_stop (handle));
    }
  }

  return B_TRY_RET;
}


b_errtype EXPORT BestSstPrimFinished (b_handletype handle)
{
  B_TRY_VARS_NO_PROG;
  
  B_TRY_BEGIN {
    B_TRY (BestSstPropSet (handle, B_SSTPAR_EVENT, B_EVENT_FINISHED));

    if (BestHasIchiban (handle)) {
      B_TRY (sst_prim_stop (handle));
    }
  }

  return B_TRY_RET;
}


b_errtype EXPORT BestSstReportStore (b_handletype handle,
				     void *report)
{
  HANDLECHECK;
  memcpy ((void *)&report_storage [handle], 
	  report,
	  *(b_int32ptr)report);
  return B_E_OK;
}


b_errtype EXPORT BestSstReportRecall (b_handletype handle,
				      void *report)
{
  HANDLECHECK;
  memcpy (report,
	  (void *)&report_storage [handle], 
	  *(b_int32ptr)&report_storage [handle]);
  return B_E_OK;
}

#endif


b_errtype EXPORT BestSstResultRead (b_handletype handle,
				    void *rpt_result)
{
  B_DECLARE_FUNCNAME ("BestSstResultRead");
  B_TRY_VARS_NO_PROG;
  b_int8  outbuf [B_SST_RPT_MAXSIZE];
  b_int16 outsize = B_LENGTH_NEGOTIATE;

  B_TRY_BEGIN {
    B_TRY_FAIL (BestHasIchiban (handle) ? B_E_OK : B_E_NOT_E2925A);
    B_TRY_FCT_PARAM_NULL_POINTER (rpt_result);
    B_TRY (BestBasicCommand (handle, CMD_SST_RPT_READ,
			     NULL, IN_SST_RPT_READ,
			     outbuf, &outsize));
    (void)BestStream2Long ((b_int32ptr)rpt_result, outbuf, outsize / 4);

#ifndef BEST_FIRMWARE
    B_TRY (BestSstReportStore (handle, rpt_result));

#endif

  }

  return (B_TRY_RET);
}


b_errtype EXPORT BestSstResultWrite (b_handletype handle,
				     void *rpt_result)
{
  B_TRY_VARS_NO_PROG;
  b_int8 inbuf [B_SST_RPT_MAXSIZE];

  B_TRY_BEGIN 
  {
    B_TRY_FAIL (BestHasIchiban (handle) ? B_E_OK : B_E_NOT_E2925A);

    if (rpt_result) 
    {
      b_int32 numbytes = *(b_int32ptr)rpt_result;
      (void)BestLong2Stream (inbuf, (b_int32ptr)rpt_result, *(b_int32ptr)rpt_result / 4);
      B_TRY (BestBasicCommandVariable (handle, CMD_SST_RPT_WRITE,
				       inbuf, (b_int16)numbytes,
				       NULL, NULL));
    }
  }

  return (B_TRY_RET);
}


#ifndef BEST_FIRMWARE

b_errtype EXPORT BestSstPrimPresent (b_handletype handle, b_int32 *value)
{
  B_TRY_VARS_NO_PROG;
  b_int8 present;

  B_TRY_BEGIN {
    B_TRY_FAIL (BestHasIchiban (handle) ? B_E_OK : B_E_NOT_E2925A);
    B_TRY (BBCReceiveByte (handle, CMD_SST_PRIM_PRESENT, &present));
    *value = present;
  }

  return B_TRY_RET;
}


b_errtype EXPORT BestSstStatusGet (
  b_handletype handle, 
  b_sststatustype status, 
  b_int32 *value
)
{
  B_DECLARE_FUNCNAME ("BestSstStatusGet");
  B_TRY_VARS_NO_PROG;

  B_TRY_BEGIN {
    B_TRY_FCT_PARAM_NULL_POINTER (value);
    B_TRY_FCT_PARAM_RANGE (status, B_SST_STATUS_TEST, B_SST_STATUS_TEST);
    B_TRY_FAIL (BestHasIchiban (handle) ? B_E_OK : B_E_NOT_E2925A);
    B_TRY (BestAbstractPropLongGet (handle, CMD_SST_STATUS_GET,
				    (b_int8)status, value));
  }

  B_ERRETURN (B_TRY_RET);
}


b_errtype EXPORT BestSstElapsedTime (b_handletype handle, b_int32 *value)
{
  B_DECLARE_FUNCNAME ("BestSstElapsedTime");
  B_TRY_VARS_NO_PROG;

  B_TRY_BEGIN {
    B_TRY_FAIL (BestHasIchiban (handle) ? B_E_OK : B_E_NOT_E2925A);
    B_TRY_FCT_PARAM_NULL_POINTER (value);
    B_TRY (BBCReceiveLong (handle, CMD_SST_ELAPSED_TIME, value));
  }

  B_ERRETURN (B_TRY_RET);
}

#endif




